<?php
	require 'include/lib.php';

	if(!isset($_GET['id']) || !intval($_GET['id'])) {
		URL::redirect('bill.php');
	}

	$id = intval($_GET['id']);

	$data = Bill::detail($id);
	if(!$data) {
		HTML::script('alert("ไม่พบข้อมูล");');
		URL::redirect('bill.php');
	}

?>
<!DOCTYPE html>
<html>
<?php include 'head.html'; ?>
<body>
	<?php include 'navbar.php'; ?>
	<div class="container">
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
				<h1>รายละเอียดบิล (เลขที่บิล: <?=intval($data['sequence']);?>)</h1>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
				<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
					<div class="panel panel-warning">
						<div class="panel-heading">
							<h3 class="center">รายการ</h3>
						</div>

						<table class="table table-hover b-table">
							<tr class="heading">
								<th width="5%">#</th>
								<th width="15%">รหัสสินค้า</th>
								<th width="39%">ชื่อสินค้า</th>
								<th width="12%">ราคา</th>
								<th width="12%">จำนวน</th>
								<th width="12%">รวม</th>
								<th width="5%">ลบ</th>
							</tr>
							<?php
								$bill_details = DB::query('SELECT * FROM bill_detail WHERE bill_id = {bill_id} ORDER BY sequence', [
									'bill_id' => intval($data['id'])
								]);

								$cnt = 0;
								$quantity = 0;
								$total = 0;
								$grand_total = 0;

								if(sizeof($bill_details) == 0) {
									echo '<tr class="heading">';
										echo '<td class="center" colspan="4">ไม่พบข้อมูลรายการขายในระบบ</td>';
									echo '</tr>';
								}
								else {
									foreach ($bill_details as $key => $bill_detail) {
										$quantity += intval($bill_detail['product_quantity']);
										$total += intval($bill_detail['product_quantity'])*floatval($bill_detail['product_price']);
										echo '<tr class="product" data-sequence="'.$bill_detail['sequence'].'">';
											echo '<input type="hidden" name="product['.$bill_detail['product_barcode'].'][bill-id]" value="'.$bill_detail['bill_id'].'">';
											echo '<input type="hidden" name="product['.$bill_detail['product_barcode'].'][sequence]" value="'.$bill_detail['sequence'].'">';
											echo '<input type="hidden" name="product['.$bill_detail['product_barcode'].'][barcode]" value="'.$bill_detail['product_barcode'].'">';
											echo '<td class="center product-order">'.(++$cnt).'</td>';
											echo '<td class="center">'.$bill_detail['product_barcode'].'</td>';
											echo '<td>'.$bill_detail['product_name'].'</td>';
											echo '<td>';
												echo '<input id="price-'.$bill_detail['product_barcode'].'" name="product['.$bill_detail['product_barcode'].'][price]" type="number" class="form-control right product-price" value="'.$bill_detail['product_price'].'" min="0.25" step="0.25" required>';
											echo '</td>';
											echo '<td>';
												echo '<input id="quantity-'.$bill_detail['product_barcode'].'" name="product['.$bill_detail['product_barcode'].'][quantity]" type="number" class="form-control right product-quantity" value="'.$bill_detail['product_quantity'].'" min="1" required>';
											echo '</td>';
											echo '<td id="sum-price-'.$bill_detail['product_barcode'].'" class="right product-sum-price" data-barcode="'.$bill_detail['product_barcode'].'">'.number_format($bill_detail['product_price']*$bill_detail['product_quantity'], 2).'</td>';

										echo '</tr>';
									}
								}
								$discount = ($data['discount_type'] == 'baht' ? floatval($data['discount']) : $total * (floatval($data['discount'])/100.0));
								$tax_show = ($total - $discount) * (floatval($data['tax_value'])/100);
								$grand_total = $total - $discount + $tax_show;
							?>
							<tr class="heading">
								<th colspan="4" class="center">รวม</th>
								<th class="right" id="total-quantity">
									<?=number_format($quantity);?>
								</th>
								<th class="right" id="sub-total">
									<?=number_format($total, 2);?>
								</th>
								<th class="center"></th>
							</tr>
							<tr class="heading">
								<th colspan="4" class="center">ส่วนลด</th>
								<td>
									<input id="discount" name="discount" class="form-control right number" type="number" min="0.00" step="0.25" value="<?=$data['discount'];?>" required/>
								</td>
								<td class="right" id="discount-bath">
									<?=number_format($discount,2);?>
								</td>
								<th class="center">
									<input id="discount-type" name="discount-type" type="checkbox" data-toggle="toggle" data-style="discount" data-size="small" data-style="ios" data-on="฿" data-off="%" data-onstyle="success" data-offstyle="success" <?=($data['discount_type'] == 'baht' ? 'checked' : '');?> >
								</th>
							</tr>
							<tr class="heading">
								<th colspan="4" class="center">
									<input id="tax" name="tax" type="checkbox" data-toggle="toggle" data-style="tax" data-on="คิดภาษี" data-off="ไม่คิดภาษี" data-onstyle="danger" <?=($data['tax_value'] > 0 ? 'checked' : '');?> />
								</th>
								<td class="center">
									<input id="tax-value" name="tax-value" class="form-control right number" type="number" min="0.00" value="<?=($data['tax_value']==0 ? 7 : (floatval($data['tax_value']) == intval($data['tax_value']) ? intval($data['tax_value']) : $data['tax_value']));?>" style="display: inline-block; width: 75%;" /> %
								</td>
								<td class="right" id="tax-show">
									<?=number_format($tax_show, 2);?>
								</td>
								<th class="center"></th>
							</tr>
							<tr class="heading">
								<th colspan="4" class="center">สุทธิ</th>
								<th class="right"</th>
								<th class="right" id="grand-total">
									<?=number_format($grand_total, 2);?>
								</th>
								<th class="center"></th>
							</tr>
						</table>
						<div class="panel-footer">
							<div class="form-group">
								<label for="">หมายเหตุ</label>
								<textarea name="remark" class="form-control" cols="30" rows="5" placeholder="หมายเหตุ" style="resize: none;" required><?=isset($data['remark']) ? $data['remark'] : '';?></textarea>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

				<div class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
					<div class="panel panel-warning">
						<div class="panel-heading">
							<h3>ข้อมูลพนักงานขาย</h3>
						</div>
						<div class="panel-body">
							<div class="form-group">
								<label for="">คำนำหน้า *</label>
								<select name="salesman-title" class="form-control" id="" required>
									<option value="" disabled selected>-- เลือกคำนำหน้า --</option>
									<option value="นาย" <?=isset($data['salesman_title']) && $data['salesman_title'] == 'นาย'? 'selected' : '';?> >นาย</option>
									<option value="นาง" <?=isset($data['salesman_title']) && $data['salesman_title'] == 'นาง'? 'selected' : '';?> >นาง</option>
									<option value="นางสาว" <?=isset($data['salesman_title']) && $data['salesman_title'] == 'นางสาว'? 'selected' : '';?> >นางสาว</option>
								</select>

							</div>
							<div class="form-group">
								<label for="">ชื่อ *</label>
								<input name="salesman-firstname" class="form-control" type="text" placeholder="ชื่อ" value="<?=isset($data['salesman_firstname']) ? $data['salesman_firstname'] : '';?>" required/>
							</div>
							<div class="form-group">
								<label for="">นามสกุล *</label>
								<input name="salesman-lastname" class="form-control" type="text" placeholder="นามสกุล" value="<?=isset($data['salesman_lastname']) ? $data['salesman_lastname'] : '';?>" required/>
							</div>
							<div class="form-group">
								<label for="">ชื่อเล่น</label>
								<input name="salesman-nickname" class="form-control" type="text" placeholder="ชื่อเล่น" value="<?=isset($data['salesman_nickname']) ? $data['salesman_nickname'] : '';?>"/>
							</div>
							<div class="form-group">
								<label for="">ที่อยู่ *</label>
								<textarea name="salesman-address" class="form-control" id="" cols="30" rows="5" placeholder="ที่อยู่" style="resize: none;" required><?=isset($data['salesman_address']) ? $data['salesman_address'] : '';?></textarea>
							</div>
							<div class="form-group">
								<label for="">โทรศัพท์ *</label>
								<input name="salesman-phone" class="form-control" type="text" placeholder="โทรศัพท์" value="<?=isset($data['salesman_phone']) ? $data['salesman_phone'] : '';?>" required/>
							</div>
							<div class="form-group">
								<label for="">มือถือ</label>
								<input name="salesman-mobile" class="form-control" type="text" placeholder="มือถือ" value="<?=isset($data['salesman_mobile']) ? $data['salesman_mobile'] : '';?>"/>
							</div>
							<div class="form-group">
								<label for="">โทรสาร</label>
								<input name="salesman-fax" class="form-control" type="text" placeholder="โทรสาร" value="<?=isset($data['salesman_fax']) ? $data['salesman_fax'] : '';?>"/>
							</div>
						</div>
					</div>
				</div>

				<?php
					$customer = Customer::detail($data['customer_id']);
				?>

				<div class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
					<div class="panel panel-warning">
						<div class="panel-heading">
							<h3>ข้อมูลลูกค้า</h3>
						</div>
						<div class="panel-body">
							<div class="form-group">
								<label for="">ชื่อ *</label>
								<textarea name="customer-name" class="form-control" cols="30" rows="5" placeholder="ชื่อ" style="resize: none;" required><?=isset($customer['name']) ? $customer['name'] : '';?></textarea>
							</div>
							<div class="form-group">
								<label for="">ชื่อเล่น</label>
								<input name="customer-nickname" class="form-control" type="text" placeholder="ชื่อเล่น" value="<?=isset($customer['nickname']) ? $customer['nickname'] : '';?>"/>
							</div>
							<div class="form-group">
								<label for="">ที่อยู่</label>
								<textarea name="customer-address" class="form-control" id="" cols="30" rows="5" placeholder="ที่อยู่" style="resize: none;"><?=isset($customer['address']) ? trim($customer['address']) : '';?></textarea>
							</div>
							<!-- <div class="form-group">
								<label for="">โทรศัพท์</label>
								<input name="customer-phone" class="form-control" type="text" placeholder="โทรศัพท์" value="<?=isset($customer['phone']) ? $customer['phone'] : '';?>"/>
							</div>
							<div class="form-group">
								<label for="">มือถือ</label>
								<input name="customer-mobile" class="form-control" type="text" placeholder="มือถือ" value="<?=isset($customer['mobile']) ? $customer['mobile'] : '';?>"/>
							</div> -->

						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- <div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
				<div class="form-group center">
					<button type="reset" class="btn btn-warning">
						<i class="fa fa-undo"></i>
						ล้าง
					</button>
					<button type="submit" class="btn btn-success">
						<i class="fa fa-plus"></i>
						แก้ไขบิล
					</button>
				</div>
			</div>
		</div> -->
	</div>
	<script type="text/javascript">

	</script>
</body>
</html>
