<?php
	require 'include/lib.php';

	if(!isset($_GET['id']) || !intval($_GET['id'])) {
		URL::redirect('bill.php');
	}

	$id = intval($_GET['id']);

	if(isset($_POST['submit']) && $_POST['submit'] == 'bill') {
		if(isset($_POST['method']) && $_POST['method'] == 'update') {
			// HTML::pre($_POST);
			$result = Bill::update($id);
			// HTML::pre($result);
		}
	}

	$data = Bill::detail($id);
	if(!$data) {
		HTML::script('alert("ไม่พบข้อมูล");');
		URL::redirect('bill.php');
	}

?>
<!DOCTYPE html>
<html>
<?php include 'head.html'; ?>
<body>
	<?php include 'navbar.php'; ?>
	<div class="container">
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
				<h1>แก้ไขบิล (เลขที่บิล: <?=intval($data['sequence']);?>)</h1>
			</div>
		</div>
		<form method="post">
			<input type="hidden" name="submit" value="bill" />
			<input type="hidden" name="method" value="update" />
			<input type="hidden" name="bill-id" value="<?=$id;?>" />
			<input type="hidden" name="sequence" value="<?=intval($data['sequence']);?>" />
			<input type="hidden" name="customer-id" value="<?=intval($data['customer_id']);?>" />
			<div class="row">
				<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
					<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
						<div class="panel panel-warning">
							<div class="panel-heading">
							<?php 	
							echo '<td class="center" width="2%">
										<a href="'.URL::to('bill-print.php?id='.$data['id']).'" target="_blank">
											<h3 class="center">ปริ้น</h3>
										</a>
										<a href="'.URL::to('bill-print-tax.php?id='.$data['id']).'" target="_blank">
											<h3 class="center">ปริ้นแบบภาษี</h3>
										</a>
										<a href="'.URL::to('bill-print-2.php?id='.$data['id']).'" target="_blank">
											<h3 class="center">ปริ้นส่ง/เสร็จ</h3>
										</a>
									</td>';
							?>		
							</div>
							<div class="panel-heading">
								<h3 class="center">รายการ</h3>
							</div>

							<table class="table table-hover b-table">
								<tr class="heading">
									<th width="5%">#</th>
									<th width="15%">รหัสสินค้า</th>
									<th width="39%">ชื่อสินค้า</th>
									<th width="12%">ราคา</th>
									<th width="12%">จำนวน</th>
									<th width="12%">รวม</th>
									<th width="5%">ลบ</th>
								</tr>
								<?php
									$bill_details = DB::query('SELECT * FROM bill_detail WHERE bill_id = {bill_id} ORDER BY sequence', [
										'bill_id' => intval($data['id'])
									]);

									$cnt = 0;
									$quantity = 0;
									$total = 0;
									$grand_total = 0;

									if(sizeof($bill_details) == 0) {
										echo '<tr class="heading">';
											echo '<td class="center" colspan="4">ไม่พบข้อมูลลูกค้าในระบบ</td>';
										echo '</tr>';
									}
									else {
										foreach ($bill_details as $key => $bill_detail) {
											$quantity += intval($bill_detail['product_quantity']);
											$total += intval($bill_detail['product_quantity'])*floatval($bill_detail['product_price']);
											echo '<tr class="product" data-sequence="'.$bill_detail['sequence'].'">';
												echo '<input type="hidden" name="product['.$bill_detail['product_barcode'].'][bill-id]" value="'.$bill_detail['bill_id'].'">';
												echo '<input type="hidden" name="product['.$bill_detail['product_barcode'].'][sequence]" value="'.$bill_detail['sequence'].'">';
												echo '<input type="hidden" name="product['.$bill_detail['product_barcode'].'][barcode]" value="'.$bill_detail['product_barcode'].'">';
												echo '<td class="center product-order">'.(++$cnt).'</td>';
												echo '<td class="center">'.$bill_detail['product_barcode'].'</td>';
												echo '<td>'.$bill_detail['product_name'].'</td>';
												echo '<td>';
													echo '<input id="price-'.$bill_detail['product_barcode'].'" name="product['.$bill_detail['product_barcode'].'][price]" type="number" class="form-control right product-price" value="'.$bill_detail['product_price'].'" min="0.25" step="0.25" required>';
												echo '</td>';
												echo '<td>';
													echo '<input id="quantity-'.$bill_detail['product_barcode'].'" name="product['.$bill_detail['product_barcode'].'][quantity]" type="number" class="form-control right product-quantity" value="'.$bill_detail['product_quantity'].'" min="1" required>';
												echo '</td>';
												echo '<td id="sum-price-'.$bill_detail['product_barcode'].'" class="right product-sum-price" data-barcode="'.$bill_detail['product_barcode'].'">'.number_format($bill_detail['product_price']*$bill_detail['product_quantity'], 2).'</td>';

												echo '<td class="center" width="10%">
													<i class="fa fa-trash fa-button delete-bill-detail"
														onclick="requestDelete('.$bill_detail['bill_id'].','.$bill_detail['sequence'].')"
													>
													</i>
												</td>';
											echo '</tr>';
										}
									}
									$discount = ($data['discount_type'] == 'baht' ? floatval($data['discount']) : $total * (floatval($data['discount'])/100.0));
									$tax_show = 0; //($total - $discount) * (floatval($data['tax_value'])/100);
									$grand_total = $total - $discount + $tax_show;
								?>
								<tr class="heading">
									<th colspan="4" class="center">รวม</th>
									<th class="right" id="total-quantity">
										<?=number_format($quantity);?>
									</th>
									<th class="right" id="sub-total">
										<?=number_format($total, 2);?>
									</th>
									<th class="center"></th>
								</tr>
								<tr class="heading">
									<th colspan="4" class="center">ส่วนลด</th>
									<td>
										<input id="discount" name="discount" class="form-control right number" type="number" min="0.00" step="0.25" value="<?=$data['discount'];?>" required/>
									</td>
									<td class="right" id="discount-bath">
										<?=number_format($discount,2);?>
									</td>
									<th class="center">
										<input id="discount-type" name="discount-type" type="checkbox" data-toggle="toggle" data-style="discount" data-size="small" data-style="ios" data-on="฿" data-off="%" data-onstyle="success" data-offstyle="success" <?=($data['discount_type'] == 'baht' ? 'checked' : '');?> >
									</th>
								</tr>
								<tr class="heading" style="display: none;">
									<th colspan="4" class="center">
										<input id="tax" name="tax" type="checkbox" data-toggle="toggle" data-style="tax" data-on="คิดภาษี" data-off="ไม่คิดภาษี" data-onstyle="danger" <?=($data['tax_value'] > 0 ? 'checked' : '');?> />
									</th>
									<td class="center">
										<input id="tax-value" name="tax-value" class="form-control right number" type="number" min="0.00" value="<?=($data['tax_value']==0 ? 7 : ($data['tax_value'] % 1 == 0 ? intval($data['tax_value']) : $data['tax_value']));?>" style="display: inline-block; width: 75%;" /> %
									</td>
									<td class="right" id="tax-show">
										<?=number_format($tax_show, 2);?>
									</td>
									<th class="center"></th>
								</tr>
								<tr class="heading">
									<th colspan="4" class="center">สุทธิ</th>
									<th class="right"</th>
									<th class="right" id="grand-total">
										<?=number_format($grand_total, 2);?>
									</th>
									<th class="center"></th>
								</tr>
							</table>
							<div class="panel-footer">
								<div class="form-group">
									<label for="">หมายเหตุ</label>
									<textarea name="remark" class="form-control" cols="30" rows="5" placeholder="หมายเหตุ" style="resize: none;"><?=isset($data['remark']) ? $data['remark'] : '';?></textarea>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

					<div class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
						<div class="panel panel-warning">
							<div class="panel-heading">
								<h3>ข้อมูลพนักงานขาย</h3>
							</div>
							<div class="panel-body">
								<div class="form-group">
									<label for="">คำนำหน้า *</label>
									<select name="salesman-title" class="form-control" id="" required>
										<option value="" disabled selected>-- เลือกคำนำหน้า --</option>
										<option value="นาย" <?=isset($data['salesman_title']) && $data['salesman_title'] == 'นาย'? 'selected' : '';?> >นาย</option>
										<option value="นาง" <?=isset($data['salesman_title']) && $data['salesman_title'] == 'นาง'? 'selected' : '';?> >นาง</option>
										<option value="นางสาว" <?=isset($data['salesman_title']) && $data['salesman_title'] == 'นางสาว'? 'selected' : '';?> >นางสาว</option>
										<option value="บริษัท" <?=isset($data['salesman_title']) && $data['salesman_title'] == 'บริษัท'? 'selected' : '';?> >บริษัท</option>
									</select>

								</div>
								<div class="form-group">
									<label for="">ชื่อ *</label>
									<input name="salesman-firstname" class="form-control" type="text" placeholder="ชื่อ" value="<?=isset($data['salesman_firstname']) ? $data['salesman_firstname'] : '';?>" required/>
								</div>
								<div class="form-group">
									<label for="">นามสกุล *</label>
									<input name="salesman-lastname" class="form-control" type="text" placeholder="นามสกุล" value="<?=isset($data['salesman_lastname']) ? $data['salesman_lastname'] : '';?>" required/>
								</div>
								<div class="form-group">
									<label for="">ชื่อเล่น</label>
									<input name="salesman-nickname" class="form-control" type="text" placeholder="ชื่อเล่น" value="<?=isset($data['salesman_nickname']) ? $data['salesman_nickname'] : '';?>"/>
								</div>
								<div class="form-group">
									<label for="">ที่อยู่ *</label>
									<textarea name="salesman-address" class="form-control" id="" cols="30" rows="5" placeholder="ที่อยู่" style="resize: none;" required><?=isset($data['salesman_address']) ? $data['salesman_address'] : '';?></textarea>
								</div>
								<div class="form-group">
									<label for="">โทรศัพท์ *</label>
									<input name="salesman-phone" class="form-control" type="text" placeholder="โทรศัพท์" value="<?=isset($data['salesman_phone']) ? $data['salesman_phone'] : '';?>" required/>
								</div>
								<div class="form-group">
									<label for="">มือถือ</label>
									<input name="salesman-mobile" class="form-control" type="text" placeholder="มือถือ" value="<?=isset($data['salesman_mobile']) ? $data['salesman_mobile'] : '';?>"/>
								</div>
								<div class="form-group">
									<label for="">เลขประจำตัวผู้เสียภาษี</label>
									<input name="salesman-fax" class="form-control" type="text" placeholder="เลขประจำตัวผู้เสียภาษี" value="<?=isset($data['salesman_fax']) ? $data['salesman_fax'] : '';?>"/>
								</div>
							</div>
						</div>
					</div>

					<?php
						$customer = Customer::detail($data['customer_id']);
					?>

					<div class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
						<div class="panel panel-warning">
							<div class="panel-heading">
								<h3>ข้อมูลลูกค้า</h3>
							</div>
							<div class="panel-body">
								<div class="form-group">
									<label for="">ชื่อ *</label>
									<textarea name="x-customer-name" class="form-control" cols="30" rows="5" placeholder="ชื่อ" style="resize: none;" required readonly><?=isset($customer['name']) ? $customer['name'] : '';?></textarea>
								</div>
								<div class="form-group">
									<label for="">ชื่อเล่น</label>
									<input name="x-customer-nickname" class="form-control" type="text" placeholder="ชื่อเล่น" value="<?=isset($customer['nickname']) ? $customer['nickname'] : '';?>" readonly />
								</div>
								<div class="form-group">
									<label for="">ที่อยู่</label>
									<textarea name="x-customer-address" class="form-control" id="" cols="30" rows="5" placeholder="ที่อยู่" style="resize: none;" readonly><?=isset($customer['address']) ? trim($customer['address']) : '';?></textarea>
								</div>
								<!-- <div class="form-group">
									<label for="">โทรศัพท์</label>
									<input name="x-customer-phone" class="form-control" type="text" placeholder="โทรศัพท์" value="<?=isset($customer['phone']) ? $customer['phone'] : '';?>"/>
								</div>
								<div class="form-group">
									<label for="">มือถือ</label>
									<input name="x-customer-mobile" class="form-control" type="text" placeholder="มือถือ" value="<?=isset($customer['mobile']) ? $customer['mobile'] : '';?>"/>
								</div> -->

							</div>
						</div>
					</div>

				</div>
			</div>
			<div class="row">
				<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
					<div class="form-group center">
						<button type="reset" class="btn btn-warning">
							<i class="fa fa-undo"></i>
							ล้าง
						</button>
						<button type="submit" class="btn btn-success">
							<i class="fa fa-plus"></i>
							แก้ไขบิล
						</button>
					</div>
				</div>
			</div>
		</form>
	</div>
	<script type="text/javascript">
		function requestDelete(id, seq) {
			if(confirm('ลบรายการนี้ (ไม่สามารถเรียกคืนได้) ?')) {
				$.ajax({
					url: '<?=URL::to('bill-detail-delete.php?delete=true&bill-id=')?>'+id+'&seq='+seq,
					method: 'get',
					success: function(response) {
						console.info(response);
						if(response == 'success') {
							$('tr[data-sequence="' + seq + '"]').remove();
							posCal();
						}
						else{
							alert('ลบรายการผิดพลาด');
						}
					}
				});
			}
		}

		function posCal() {

			if($('.product-order').length < 2) {
				$('.delete-bill-detail').hide();
			}

			let grandTotal = 0;
			// order
			$('.product-order').each(function(i) {
				$(this).html(i+1);
			});

			// sum quantity
			let sumQuantity = 0;
			$('.product-quantity').map(function() {
				let v = parseInt($(this).val());
				sumQuantity += v;
				return v;
			});
			$('#total-quantity').html(number_format(sumQuantity));

			// sum price
			let sumPrice = 0;
			$('.product-sum-price').map(function() {
				let p = parseFloat($('#price-' + $(this).attr('data-barcode')).val());
				let q = parseInt($('#quantity-' + $(this).attr('data-barcode')).val());
				let sp = (p*q);

				$('#sum-price-' + $(this).attr('data-barcode')).html(number_format(sp, 2));

				sumPrice += sp;
				return p;
			});
			$('#sub-total').html(number_format(sumPrice, 2));

			// cal discount
			let discount = parseFloat($('#discount').val() || 0);

			if($('#discount-type').prop('checked')) {
				grandTotal = sumPrice - discount;
			}
			else {
				grandTotal = sumPrice - (sumPrice * (discount/100));
				discount = (sumPrice * (discount/100));
			}

			if(discount > sumPrice) {
				$('#discount-bath').html(number_format(sumPrice, 2));
			}
			else if(discount < 0) {
				$('#discount-bath').html('0.00');
			}
			else {
				$('#discount-bath').html(number_format(discount, 2));
			}

			// cal tax

			// if($('#tax').prop('checked') && grandTotal > 0) {
			// 	let tax_value = $('#tax-value').val();
			// 	$('#tax-show').html(number_format(grandTotal * (tax_value/100), 2));
			// 	grandTotal = grandTotal + (grandTotal * (tax_value/100));
			// }
			// else {
			// 	$('#tax-show').html('0.00');
			// }

			// grandTotal


			$('#grand-total').html(number_format(grandTotal >= 0 ? grandTotal : 0, 2));
		}

		$(document).ready(function() {
			$('#discount, #tax-value, .product-price, .product-quantity').bind('click focus keyup', function(e) {
				if(e.type != 'keyup') {
					$(this).select();
				}
				posCal();
			});

			$('#discount-type, #tax').change(function(e) {
				posCal();
			});

			if($('.product-order').length < 2) {
				$('.delete-bill-detail').hide();
			}
		});
	</script>
	<?php
		if(isset($result)) {
			if(!$result['error']) {
				echo HTML::inputAlert('textarea[name="remark"]', 'success', 'แก้ไขบิลสำเร็จ');
			}
		}
	?>
</body>
</html>
