<?php
	require 'include/lib.php';

	$customer_show = false;
	if(isset($_GET['customer-id']) && intval($_GET['customer-id']) > 0) {
		$customer_show = Customer::detail(intval($_GET['customer-id']));
	}
?>
<!DOCTYPE html>
<html>
<?php include 'head.html'; ?>
<body>
	<?php include 'navbar.php'; ?>
	<div class="container">
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
				<h1>จัดการบิล</h1>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
				<div class="panel panel-warning">
					<div class="panel-body">
						<form method="get" class="form-inline">
							<label for="">วันที่</label>
							<input type="date" name="date-from" class="form-control" value="<?=isset($_GET['date-from']) ? $_GET['date-from'] : '';?>">
							&emsp;
							<label for="">ถึง</label>
							<input type="date" name="date-to" class="form-control" value="<?=isset($_GET['date-to']) ? $_GET['date-to'] : '';?>">

							<br/>
							<br/>

							<label for="">ลูกค้า</label>
							<input type="hidden" id="customer-id-hidden" name="customer-id" value="<?=($customer_show && $customer_show['id'] ? $customer_show['id'] : '');?>" />
							<input class="form-control center number" id="customer-id" type="text" placeholder="ค้นหาลูกค้า" size="50" value="<?=($customer_show  ? ($customer_show['name'].($customer_show['nickname'] ? ' ('.$customer_show['nickname'].')' : '')) : '');?>" autocomplete="off"/>
							&emsp;
							<label for="">ภาษี</label>
							<select name="tax" class="form-control" id="" required>
								<option value="all" selected>ทั้งหมด</option>
								<option value="tax" <?=isset($_GET['tax']) && $_GET['tax'] == 'tax'? 'selected' : '';?> >คิดภาษี</option>
								<option value="notax" <?=isset($_GET['tax']) && $_GET['tax'] == 'notax'? 'selected' : '';?> >ไม่คิดภาษี</option>
							</select>

							<br/>
							<br/>

							<button class="btn btn-primary" type="submit">
								<i class="fa fa-search"></i>
								ค้นหา
							</button>
							<button type="button" class="btn btn-warning" onclick="window.location='<?=URL::to('bill.php');?>'">
								<i class="fa fa-undo"></i>
								ล้าง
							</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
				<table class="table table-hover b-table">
					<tr class="heading">
						<th width="10%">เลขที่บิล</th>
						<th width="10%">วันที่</th>
						<th width="30%">ลูกค้า</th>
						<th width="5%">ภาษี</th>
						<th width="15%">สุทธิ</th>
						<th width="15%" colspan="7">แก้ไข / ลบ</th>
					</tr>
					<?php
						$datas = Bill::lists();

						if(sizeof($datas) == 0) {
							echo '<tr class="heading">';
								echo '<td class="center" colspan="8">ไม่พบข้อมูลการขายที่ค้นหาในระบบ</td>';
							echo '</tr>';
						}
						else {
							foreach ($datas as $key => $data) {

								$customer = Customer::detail($data['customer_id']);

								echo '<tr>';
									echo '<td class="center">'.$data['sequence'].'</td>';
									echo '<td class="center">'.ThaiDate::toThaiDate($data['created_at'], 'd m Y').'</td>';
									echo '<td>'.$customer['nickname'].($customer['nickname'] ? ' ('.$customer['nickname'].')' : '').'</td>';
									echo '<td class="center">'.($data['tax_value'] > 0 ? ($data['tax_value'] % 1 == 0 ? intval($data['tax_value']) : number_format($data['tax_value'], 2)).'%' : '-').'</td>';
									echo '<td class="right">'.number_format($data['total'], 2).'</td>';

									echo '<td class="center" width="5%">
										<a href="'.URL::to('bill-print.php?id='.$data['id']).'" target="_blank">
											<i class="fa fa-print fa-button"></i>
										</a>
									</td>';
									echo '<td class="center" width="5%">
										<a href="'.URL::to('bill-print-tax.php?id='.$data['id']).'" target="_blank">
											ภาษี
										</a>
									</td>';
									echo '<td class="center" width="5%">
										<a href="'.URL::to('bill-print-2.php?id='.$data['id']).'" target="_blank">
											ส่ง/ใบเสร็จ
										</a>
									</td>';
									echo '<td class="center" width="5%">
										<a href="'.URL::to('bill-print-3.php?id='.$data['id']).'" target="_blank">
											ส่ง/ใบกำกับ
										</a>
									</td>';
									echo '<td class="center" width="5%">
										<a href="'.URL::to('bill-print-notax.php?id='.$data['id']).'" target="_blank">
											notax
										</a>
									</td>';
									echo '<td class="center" width="5%">
										<i class="fa fa-edit fa-button"
											onclick="window.location=\''.URL::to('bill-update.php?id='.$data['id']).'\'"
										>
										</i>
									</td>';
									echo '<td class="center" width="5%">
										<i class="fa fa-trash fa-button"
											onclick="requestDelete('.$data['id'].')"
										>
										</i>
									</td>';
								echo '</tr>';
							}
						}
					?>
				</table>
			</div>
		</div>
	</div>
	<script type="text/javascript">
		function requestDelete(id) {
			if(confirm('ลบรายการซื้อขายและบิลนี้ ?')) {
				window.location = '<?=URL::to('bill-delete.php?delete=true&id=')?>'+id;
			}
		}

		$(document).ready(function() {
			$('#customer-id').focus(function() {
				$(this).select();
			});

			$('#customer-id').keyup(function(e) {
				if(e.which != 13) {
					$('#customer-id-hidden').val(void(0));
				}

				let v = $(this).val().trim();

				$('#customer-id').autocomplete({
					delay: 100,
					source: '<?=URL::to('customer-get.php?search=');?>'+v,
					minLength: 1,
					select: function(event, ui) {
						console.log("Selected: " + ui.item.name + " aka " + ui.item.id);
						$('#customer-id-hidden').val(ui.item.id);
					},
					position: {
						my: 'right bottom',
						at: 'right top'
					}
				});
			});
		});
	</script>
</body>
</html>
