<?php
if($_SERVER['SCRIPT_NAME']=='/include/acti.php')exit();
class Acti
{
	public static function getAllActis($start = 0, $count = 10){
		$actis = DB::q('SELECT
			acti_id,
			acti_title,
			acti_thumbnail,
			acti_text,
			acti_datetime,
			acti_views,
			"เจ้าหน้าที่" AS user_show_name
		FROM
			acti
		ORDER BY
			acti_datetime DESC
		LIMIT '.$start.', '.$count);
		if(!$actis)return false;
		return $actis;
	}

	public static function insertActi(){
		if(!User::isAdmin()){
			return false;
		}
		if(!isset($_POST['acti-title'])||trim($_POST['acti-title'])==''){
			return false;
		}
		if(!isset($_POST['acti-text'])||trim($_POST['acti-text'])==''){
			return false;
		}


		$actiId = self::getNextId();
		$actiTitle = trim($_POST['acti-title']);
		$actiText = trim($_POST['acti-text']);
		

		$sql = 'INSERT INTO acti(
			acti_id, acti_title, acti_text, acti_datetime
		) VALUES (
			{id}, "{title}", "{text}", NOW()
		)';

		$q = DB::exc($sql,
		[	
			'id'=>$actiId,
			'title'=>$actiTitle,
			'text'=>$actiText,
		]);

		if(!$q)return false;

		if( sizeof($_FILES) > 0 ){

			if( isset($_FILES['acti-image']['tmp_name']) && trim($_FILES['acti-image']['tmp_name']) != ''){
				$actiThumbnailName = 'acti_image_'.ThaiDate::getTimeStamp();
				$f = self::uploadActiImage($actiThumbnailName);
				if(!$f){
					self::deleteActi($actiId);
					return false;
				}
				$f = PATH::$IMAGEACTI.$f;
				if(!self::updateActiImage($actiId, $f )) {
					self::unlinkActiImage($f);
					return false;
				}
			}

			if( isset($_FILES['acti-file']['tmp_name']) && trim($_FILES['acti-file']['tmp_name']) != '' ){
				$actiThumbnailName = 'acti_file_'.ThaiDate::getTimeStamp();
				$f = self::uploadActiFile($actiThumbnailName);
				if(!$f){
					self::deleteActi($actiId);
					return false;
				}
				$f = PATH::$IMAGEACTI.$f;
				if(!self::updateActiFile($actiId, $f ,trim($_FILES['acti-file']['name']))) {
					self::unlinkActiImage($f);
					return false;
				}
			}
			
		}
		return true;
	}

	private static function unlinkActiImage($fn){
		if(!file_exists($fn))return false;
		if(!unlink($fn))return false;
		return true;
	}

	private static function uploadActiImage($newName){
		$f = FileManager::requestFile('acti-image');
		if(!$f){
			return false;
		}
		return FileManager::uploadFile($f, PATH::$IMAGEACTI_REAL, $newName);
	}

	private static function uploadActiFile($newName){
		$f = FileManager::requestFile('acti-file');
		if(!$f){
			return false;
		}
		return FileManager::uploadFile($f, PATH::$IMAGEACTI_REAL, $newName);
	}

	private static function updateActiImage($actiId, $f){
		$sql = 'UPDATE acti SET acti_thumbnail = "{f}" WHERE acti_id = {acti_id}';
		$q = DB::exc($sql, ['acti_id'=>$actiId, 'f'=>$f]);
		if(!$q)return false;
		return true;
	}

	private static function updateActiFile($newsId, $f, $fn){
		$sql = 'UPDATE acti SET acti_file = "{f}", acti_file_name = "{fn}" WHERE acti_id = {acti_id}';
		$q = DB::exc($sql, ['acti_id'=>$newsId, 'f'=>$f, 'fn'=>$fn]);
		if(!$q)return false;
		return true;
	}

	public static function deleteActi($actiId){
		$sql = 'DELETE FROM acti WHERE acti_id = {acti_id}';
		$q = DB::exc($sql, ['acti_id'=>$actiId]);
		if(!$q)return false;
		return true;
	}

	public static function updateActi(){
		if(!User::isAdmin())return false;
		if(!isset($_POST['acti-id'])||intval($_POST['acti-id'])<=0) {
			return false;
		}
		if(!isset($_POST['acti-title'])||trim($_POST['acti-title'])==''){
			return false;
		}
		if(!isset($_POST['acti-text'])||trim($_POST['acti-text'])==''){
			return false;
		}


		$actiId = intval($_POST['acti-id']);
		$actiTitle = trim($_POST['acti-title']);
		$actiText = trim($_POST['acti-text']);

		$delActiFile = ( isset($_POST['delete-acti-file']) && trim($_POST['delete-acti-file'])=='daf' ? ', acti_file = NULL, acti_file_name = NULL ' : '' );

	
		$sql = 'UPDATE acti
		SET	
			acti_title = "{title}",
			acti_text = "{text}", 
			acti_datetime = NOW()
			{actifile}

		WHERE 
			acti_id = {acti_id}';

		$q = DB::exc($sql, [
			'title'=>$actiTitle, 
			'text'=>$actiText, 
			'acti_id'=>$actiId,			
			'actifile'=>$delActiFile
		]);

		if( isset($_FILES['acti-image']['tmp_name']) && trim($_FILES['acti-image']['tmp_name']) != ''){
			$actiThumbnailName = 'acti_image_'.ThaiDate::getTimeStamp();
			$f = self::uploadActiImage($actiThumbnailName);
			if(!$f){
				
			}else{
				$f = PATH::$IMAGEACTI.$f;
				if(!self::updateActiImage($actiId, $f )) {
					return false;
				}
			}
		}

		if( isset($_FILES['acti-file']['tmp_name']) && trim($_FILES['acti-file']['tmp_name']) != '' ){
			$actiThumbnailName = 'acti_file_'.ThaiDate::getTimeStamp();
			$f = self::uploadActiFile($actiThumbnailName);
			if(!$f){
				
			}else{
				$f = PATH::$IMAGEACTI.$f;
				if(!self::updateActiFile($actiId, $f ,trim($_FILES['acti-file']['name']))) {
					return false;
				}
			}
		}
		return true;

	}

	private static function getNextId(){
		return (intval(DB::q('SELECT MAX(acti_id) AS id FROM acti')[0]['id'])+1);
	}

	public static function readActi($actiId){
		if(!is_numeric($actiId)){
			return false;
		}

		if(!User::isAdmin()){
			$sql = 'UPDATE acti SET acti_views = (acti_views+1) WHERE acti_id = {acti_id}';
			$stat = DB::exc($sql, ['acti_id'=>$actiId]);
			if(!$stat){
				return false;
			}
		}

		$acti = DB::q('SELECT
			acti_id,
			acti_title,
			acti_thumbnail,
			acti_file,
			acti_file_name,
			acti_text,
			acti_datetime,
			acti_views,
			"เจ้าหน้าที่" AS user_show_name
		FROM
			acti
		WHERE acti_id = {acti_id}
		LIMIT 1',
		['acti_id'=>$actiId]);

		if(!$acti)return false;
		return $acti[0];
	}

}
function captureActi(){
	if(isset($_POST['insert-acti']) && isset($_POST['acti-title']) && isset($_POST['acti-text'])){
		if(!Acti::insertActi()){
			URL::redirect('error.php');
		}
		URL::redirect('activities-all.php');
	}
	if(isset($_POST['update-acti']) && isset($_POST['acti-title']) && isset($_POST['acti-text'])){
		if(!Acti::updateActi()){
			exit();
			URL::redirect('error.php');
		}
		URL::redirect('backend-activities.php');
	}
}

function captureActiDelete(){
	if( isset($_GET['acti_id']) && intval($_GET['acti_id']) > 0 ){
		if(!Acti::deleteActi(intval($_GET['acti_id']))){
			URL::redirect('error.php');
		}
		URL::redirect('backend-activities.php');
	}
}