<?php
if($_SERVER['SCRIPT_NAME']=='/include/news.php')exit();
class News
{
	public static function getAllNews($start = 0, $count = 10){
		$news = DB::q('SELECT
			news_id,
			news_title,
			news_thumbnail,
			news_text,
			news_datetime,
			news_views,
			"เจ้าหน้าที่" AS user_show_name
		FROM
			news
		ORDER BY
			news_datetime DESC
		LIMIT '.$start.', '.$count);
		if(!$news)return false;
		return $news;
	}

	public static function insertNews(){
		if(!User::isAdmin()){
			return false;
		}
		if(!isset($_POST['news-title'])||trim($_POST['news-title'])==''){
			return false;
		}
		if(!isset($_POST['news-text'])||trim($_POST['news-text'])==''){
			return false;
		}


		$newsId = self::getNextId();
		$newsTitle = trim($_POST['news-title']);
		$newsText = trim($_POST['news-text']);
		

		$sql = 'INSERT INTO news(
			news_id, news_title, news_text, news_datetime
		) VALUES (
			{id}, "{title}", "{text}", NOW()
		)';

		$q = DB::exc($sql,
		[	
			'id'=>$newsId,
			'title'=>$newsTitle,
			'text'=>$newsText,
		]);

		if(!$q)return false;

		if( sizeof($_FILES) > 0 ){

			if( isset($_FILES['news-image']['tmp_name']) && trim($_FILES['news-image']['tmp_name']) != ''){
				$newsThumbnailName = 'news_image_'.ThaiDate::getTimeStamp();
				$f = self::uploadNewsImage($newsThumbnailName);
				if(!$f){
					self::deleteNews($newsId);
					return false;
				}
				$f = PATH::$IMAGENEWS.$f;
				if(!self::updateNewsImage($newsId, $f )) {
					self::unlinkNewsImage($f);
					return false;
				}
			}

			if( isset($_FILES['news-file']['tmp_name']) && trim($_FILES['news-file']['tmp_name']) != '' ){
				$newsThumbnailName = 'news_file_'.ThaiDate::getTimeStamp();
				$f = self::uploadNewsFile($newsThumbnailName);
				if(!$f){
					self::deleteNews($newsId);
					return false;
				}
				$f = PATH::$IMAGENEWS.$f;
				if(!self::updateNewsFile($newsId, $f ,trim($_FILES['news-file']['name']))) {
					self::unlinkNewsImage($f);
					return false;
				}
			}
			
		}
		return true;
	}

	private static function unlinkNewsImage($fn){
		if(!file_exists($fn))return false;
		if(!unlink($fn))return false;
		return true;
	}

	private static function uploadNewsImage($newName){
		$f = FileManager::requestFile('news-image');
		if(!$f){
			return false;
		}
		return FileManager::uploadFile($f, PATH::$IMAGENEWS_REAL, $newName);
	}

	private static function uploadNewsFile($newName){
		$f = FileManager::requestFile('news-file');
		if(!$f){
			return false;
		}
		return FileManager::uploadFile($f, PATH::$IMAGENEWS_REAL, $newName);
	}

	private static function updateNewsImage($newsId, $f){
		$sql = 'UPDATE news SET news_thumbnail = "{f}" WHERE news_id = {news_id}';
		$q = DB::exc($sql, ['news_id'=>$newsId, 'f'=>$f]);
		if(!$q)return false;
		return true;
	}

	private static function updateNewsFile($newsId, $f, $fn){
		$sql = 'UPDATE news SET news_file = "{f}", news_file_name = "{fn}" WHERE news_id = {news_id}';
		$q = DB::exc($sql, ['news_id'=>$newsId, 'f'=>$f, 'fn'=>$fn]);
		if(!$q)return false;
		return true;
	}

	public static function deleteNews($newsId){
		if(!User::isAdmin()){
			return false;
		}
		$sql = 'DELETE FROM news WHERE news_id = {news_id}';
		$q = DB::exc($sql, ['news_id'=>$newsId]);
		if(!$q)return false;
		return true;
	}

	public static function updateNews(){
		if(!User::isAdmin())return false;
		if(!isset($_POST['news-id'])||intval($_POST['news-id'])<=0) {
			return false;
		}
		if(!isset($_POST['news-title'])||trim($_POST['news-title'])==''){
			return false;
		}
		if(!isset($_POST['news-text'])||trim($_POST['news-text'])==''){
			return false;
		}


		$newsId = intval($_POST['news-id']);
		$newsTitle = trim($_POST['news-title']);
		$newsText = trim($_POST['news-text']);

		$delNewsFile = ( isset($_POST['delete-news-file']) && trim($_POST['delete-news-file'])=='dnf' ? ', news_file = NULL, news_file_name = NULL ' : '' );

	
		$sql = 'UPDATE news
		SET	
			news_title = "{title}",
			news_text = "{text}", 
			news_datetime = NOW()
			{newsfile}

		WHERE 
			news_id = {news_id}';

		$q = DB::exc($sql, [
			'title'=>$newsTitle, 
			'text'=>$newsText, 
			'news_id'=>$newsId,			
			'newsfile'=>$delNewsFile
		]);

		if( isset($_FILES['news-image']['tmp_name']) && trim($_FILES['news-image']['tmp_name']) != ''){
			$newsThumbnailName = 'news_image_'.ThaiDate::getTimeStamp();
			$f = self::uploadNewsImage($newsThumbnailName);
			if(!$f){
				
			}else{
				$f = PATH::$IMAGENEWS.$f;
				if(!self::updateNewsImage($newsId, $f )) {
					return false;
				}
			}
		}

		if( isset($_FILES['news-file']['tmp_name']) && trim($_FILES['news-file']['tmp_name']) != '' ){
			$newsThumbnailName = 'news_file_'.ThaiDate::getTimeStamp();
			$f = self::uploadNewsFile($newsThumbnailName);
			if(!$f){
				
			}else{
				$f = PATH::$IMAGENEWS.$f;
				if(!self::updateNewsFile($newsId, $f ,trim($_FILES['news-file']['name']))) {
					return false;
				}
			}
		}
		return true;

	}

	private static function getNextId(){
		return (intval(DB::q('SELECT MAX(news_id) AS id FROM news')[0]['id'])+1);
	}

	public static function readNews($newsId){
		if(!is_numeric($newsId)){
			return false;
		}

		if(!User::isAdmin()){
			$sql = 'UPDATE news SET news_views = (news_views+1) WHERE news_id = {news_id}';
			$stat = DB::exc($sql, ['news_id'=>$newsId]);
			if(!$stat){
				return false;
			}
		}

		$news = DB::q('SELECT
			news_id,
			news_title,
			news_thumbnail,
			news_file,
			news_file_name,
			news_text,
			news_datetime,
			news_views,
			"เจ้าหน้าที่" AS user_show_name
		FROM
			news
		WHERE news_id = {news_id}
		LIMIT 1',
		['news_id'=>$newsId]);

		if(!$news)return false;
		return $news[0];
	}

}
function captureNews(){
	if(isset($_POST['insert-news']) && isset($_POST['news-title']) && isset($_POST['news-text'])){
		if(!News::insertNews()){
			URL::redirect('error.php');
		}
		URL::redirect('news-all.php');
	}

	if(isset($_POST['update-news']) && isset($_POST['news-title']) && isset($_POST['news-text'])){
		if(!News::updateNews()){
			URL::redirect('error.php');
		}
		URL::redirect('backend-news.php');
	}
}

function captureNewsDelete(){
	if( isset($_GET['news_id']) && intval($_GET['news_id']) > 0 ){
		if(!News::deleteNews(intval($_GET['news_id']))){
			URL::redirect('error.php');
		}
		URL::redirect('backend-news.php');
	}
}