<?php
class Product {
	const TABLE_NAME = 'product';

	const FIELDS = [
		'name' => [
			'type' => 'string',
			'required' => true,
			'search' => true
		],
		'description' => [
			'type' => 'string',
			'required' => false,
		],
		'price' => [
			'type' => 'number',
			'required' => true,
			'default' => 0,
		],
		'barcode' => [
			'type' => 'string',
			'required' => true,
			'default' => 0,
			'search' => true
		],
	];

	public static function create() {
		if(!self::validate()) {
			return [
				'error' => true,
				'result' => 'invalid'
			];
		}

		if(isset($_POST['barcode'])) {
			$barcode_dup = DB::query('SELECT * FROM {table} WHERE barcode = "{barcode}"', [
				'table' => self::TABLE_NAME,
				'barcode' => trim($_POST['barcode']),
			]);
			if(sizeof($barcode_dup) > 0) {
				return [
					'error' => true,
					'result' => 'barcode_dup'
				];
			}
		}

		if(isset($_POST['name'])) {
			$name_dup = DB::query('SELECT * FROM {table} WHERE name LIKE "{name}"', [
				'table' => self::TABLE_NAME,
				'name' => trim($_POST['name']),
			]);
			if(sizeof($name_dup) > 0) {
				return [
					'error' => true,
					'result' => 'name_dup'
				];
			}
		}

		$result = DB::execute('INSERT INTO {table} ('.Validator::get_insert_field_string(self::FIELDS).') VALUES ('.Validator::get_insert_data_string(self::FIELDS, 'post').')', [
			'table' => self::TABLE_NAME,
		]);

		if(!$result) {
			return [
				'error' => true,
				'result' => 'insert_error'
			];
		}

		$id = DB::get_last_id();

		$result = DB::query('SELECT * FROM {table} WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		if(sizeof($result) < 1) {
			return [
				'error' => true,
				'result' => 'insert_error'
			];
		}

		return [
			'error' => false,
			'result' => $result[0]
		];
	}

	public static function update($id) {
		if(!self::validate()) {
			return [
				'error' => true,
				'result' => 'invalid'
			];
		}

		$id = intval($id);

		if(isset($_POST['barcode'])) {
			$barcode_dup = DB::query('SELECT * FROM {table} WHERE barcode = "{barcode}" AND id != {id}', [
				'table' => self::TABLE_NAME,
				'barcode' => trim($_POST['barcode']),
				'id' => $id
			]);
			if(sizeof($barcode_dup) > 0) {
				return [
					'error' => true,
					'result' => 'barcode_dup'
				];
			}
		}

		if(isset($_POST['name'])) {
			$name_dup = DB::query('SELECT * FROM {table} WHERE name LIKE "{name}" AND id != {id}', [
				'table' => self::TABLE_NAME,
				'name' => trim($_POST['name']),
				'id' => $id
			]);
			if(sizeof($name_dup) > 0) {
				return [
					'error' => true,
					'result' => 'name_dup'
				];
			}
		}
		

		$result = DB::execute('UPDATE {table} SET '.Validator::get_update_data_string(self::FIELDS, 'post').' WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		if(!$result) {
			return [
				'error' => true,
				'result' => 'update_error'
			];
		}

		DB::execute('UPDATE {table} SET updated_at = NOW() WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		if(!$result) {
			return [
				'error' => true,
				'result' => 'update_error'
			];
		}

		$result = DB::query('SELECT * FROM {table} WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		if(sizeof($result) < 1) {
			return [
				'error' => true,
				'result' => 'update_error'
			];
		}

		return [
			'error' => false,
			'result' => $result[0]
		];
	}

	public static function delete($id) {
		$id = intval($id);

		return DB::execute('DELETE FROM {table} WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);
	}

	public static function detail($id) {
		$id = intval($id);

		$result = DB::query('SELECT *
			FROM {table}
			WHERE {table}.id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		return sizeof($result) == 0 ? false : $result[0];
	}

	public static function lists($start=0, $limit=PERPAGE, $order_by='id', $order='ASC') {
		$filter_barcode = '1';
		$filter_name = '1';

		if(isset($_GET['barcode'])) {
			$get_barcode = trim($_GET['barcode']);
			if($get_barcode != '') {
				$filter_barcode = 'barcode LIKE "%'.$get_barcode.'%"';
			}
		}

		if(isset($_GET['name'])) {
			$get_name = trim($_GET['name']);
			if($get_name != '') {
				$filter_name = 'name LIKE "%'.$get_name.'%"';
			}
		}

		return DB::query('SELECT * FROM {table} WHERE '.$filter_barcode.' AND '.$filter_name.' ORDER BY {order_by} {order}', [
			'table' => self::TABLE_NAME,
			'start' => $start,
			'limit' => $limit,
			'order_by' => $order_by,
			'order' => $order,
		]);
	}

	public static function search($start=0, $limit=PERPAGE, $order_by='id', $order='ASC') {
		$filter_barcode = '0';
		$filter_name = '0';

		if(isset($_GET['search'])) {
			$get_search = trim($_GET['search']);
			if($get_search != '') {
				$filter_barcode = 'barcode LIKE "%'.$get_search.'%"';
				$filter_name = 'name LIKE "%'.$get_search.'%"';
			}
		}

		return DB::query('SELECT * FROM {table} WHERE '.$filter_barcode.' OR '.$filter_name.' ORDER BY {order_by} {order}', [
			'table' => self::TABLE_NAME,
			'start' => $start,
			'limit' => $limit,
			'order_by' => $order_by,
			'order' => $order,
		]);
	}

	public static function get() {
		if(isset($_GET['barcode'])) {
			$get_search = trim($_GET['barcode']);
			if($get_search != '') {
				$filter_barcode = 'barcode LIKE "%'.$get_search.'%"';
			}
		}

		$result =  DB::query('SELECT * FROM {table} WHERE '.$filter_barcode.' LIMIT 1', [
			'table' => self::TABLE_NAME,
		]);

		return sizeof($result) == 0 ? (object)[] : $result[0];
	}

	public static function validate() {
		return Validator::validate(self::FIELDS, 'post');
	}
}
?>
