<?php
	require 'include/lib.php';

	// HTML::pre($_POST);

	if(isset($_POST['submit']) && $_POST['submit'] == 'bill') {
		if(isset($_POST['method']) && $_POST['method'] == 'create') {
			$result = Bill::create();
			if(!$result['error']) {
				HTML::script('alert("บันทึกข้อมูลการขายสำเร็จ");');
				URL::redirect('bill-update.php?id='.$result['result']['id']);
			}
		}
	}
?>
<!DOCTYPE html>
<html>
<?php include 'head.html'; ?>
<body>
	<?php include 'navbar.php'; ?>
	<?php include 'addbar.php'; ?>
	<div class="container">
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
				<h1>ขายสินค้า</h1>
			</div>
		</div>
		<div class="row no-product">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
				<div class="alert alert-danger">
					ไม่พบสินค้านี้ในระบบ
					<a href="<?=URL::to('product-create.php');?>" target="_blank">
						เพิ่มสินค้า
					</a>
				</div>
			</div>
		</div>
		<form method="post" id="main-form">
			<input type="hidden" name="submit" value="bill" />
			<input type="hidden" name="method" value="create" />
			<input type="hidden" name="invoiced" value="0" />
			<div class="row">
				<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
					<table class="table table-hover b-table">
						<tr class="heading">
							<th width="7%">#</th>
							<th width="15%">รหัสสินค้า</th>
							<th width="34%">ชื่อสินค้า</th>
							<th width="13%">ราคา</th>
							<th width="10%">จำนวน</th>
							<th width="16%">รวม</th>
							<th width="5%">
								<i class="fa fa-trash fa-button cancel-all"></i>
							</th>
						</tr>
						<tr class="heading" id="holder-row">
							<td class="center" colspan="7"><h3>แสกนบาร์โค้ดสินค้า หรือเพิ่มสินค้าด้านล่าง</h3></td>
						</tr>

						<tr class="heading">
							<th colspan="4">รวม</th>
							<td class="right" id="total-quantity">
								0
							</td>
							<th class="right" id="sub-total">
								0.00
							</th>
							<td class="center">
								<i class="fa fa-trash fa-button cancel-all"></i>
							</td>
						</tr>

						<tr>
							<th colspan="4">ส่วนลด</td>
							<td>
								<input id="discount" name="discount" class="form-control right number" type="number" min="0.00" step="0.25" value="0.00" required/>
							</td>
							<td class="right" id="discount-bath">
								0.00
							</td>
							<td>
								<input id="discount-type" name="discount-type" type="checkbox" checked data-toggle="toggle" data-style="discount" data-size="small" data-style="ios" data-on="฿" data-off="%" data-onstyle="success" data-offstyle="success">
							</td>
						</tr>

						<tr style="display: none;">
							<th colspan="4">
								<input id="tax" name="tax" type="checkbox" data-toggle="toggle" data-style="tax" data-on="คิดภาษี" data-off="ไม่คิดภาษี" data-onstyle="danger" />
							</td>
							<td class="center">
								<input id="tax-value" name="tax-value" class="form-control right number" type="number" min="0.00" value="7" style="display: inline-block; width: 75%;" /> %
							</td>
							<td class="right" id="tax-show">
								0.00
							</td>
							<td></td>
						</tr>

						<tr class="heading">
							<th colspan="4">สุทธิ</td>
							<td></td>
							<th class="right" id="grand-total">
								0.00
							</th>
							<th></th>
						</tr>

					</table>
				</div>
			</div>
			<div class="row no-product">
				<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
					<div class="alert alert-danger">
						ไม่พบสินค้านี้ในระบบ
						<a href="<?=URL::to('product-create.php');?>" target="_blank">
							เพิ่มสินค้า
						</a>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
					<table class="table b-table" style="width: 60%; margin: auto;">
						<tr>
							<th width="20%">
								พนักงานขาย *
							</th>
							<td colspan="2">
								<select class="form-control" name="salesman-id" id="salesman-id" style="padding: 0 5px; text-align-last: center;" required>
									<option value="" disabled selected>-- เลือกพนักงานขาย --</option>
									<?php
										$datas = Salesman::lists();

										if(sizeof($datas) > 0) {
											$cnt = 0;
											foreach ($datas as $key => $data) {
												echo '<option value="'.$data['id'].'">'.$data['title'].$data['firstname'].' '.$data['lastname'].($data['nickname'] ? ' ('.$data['nickname'].')' : '').'</option>';;
											}
										}
									?>
								</select>
							</td>
						</tr>
						<tr>
							<th class="center">
								ลูกค้า *
							</th>
							<td>
								<input type="hidden" id="customer-id-hidden" name="customer-id">
								<input class="form-control center number" id="customer-id" type="text" placeholder="ค้นหาลูกค้า" required />
							</td>
							<!-- <td class="center">
								<input id="new-customer" name="new-customer" type="checkbox" data-toggle="toggle" data-style="tax" data-off="ลูกค้าเก่า" data-on="<i class='fa fa-plus'></i> ลูกค้าใหม่" data-onstyle="primary" />
							</td> -->
						</tr>
						<!-- <tr id="new-customer-row">
							<td colspan="3" class="left">
								<div class="form-group">
									<label for="">ชื่อลูกค้า *</label>
									<textarea class="form-control" name="customer-name" cols="30" rows="1" style="resize: none;" placeholder="ชื่อลูกค้า" required disabled></textarea>
								</div>
								<div class="form-group">
									<label for="">ชื่อเล่น</label>
									<input type="text" name="customer-nickname" class="form-control" placeholder="ชื่อเล่น" disabled>
								</div>
								<div class="form-group">
									<label for="">ที่อยู่</label>
									<textarea class="form-control" name="customer-address" id="" cols="30" rows="1" placeholder="ที่อยู่" style="resize: none;" disabled></textarea>
								</div>
								<div class="form-group form-inline center">
									<label for="">โทรศัพท์</label>
									<input type="text" name="customer-phone" class="form-control" placeholder="โทรศัพท์" style="width: 33%;" disabled>
									&emsp;
									<label for="">มือถือ</label>
									<input type="text" name="customer-mobile" class="form-control" placeholder="มือถือ" style="width: 33%;" disabled>
								</div>
							</td>
						</tr> -->
						<tr>
							<th>
								เปลี่ยน
							</th>
							<td colspan="2" class="left">
								<textarea class="form-control" id="remark" name="remark" cols="30" rows="2" placeholder="เปลี่ยน" style="resize: none;"></textarea>
							</td>
						</tr>

						<tr>
							<td colspan="3" class="center">
								<!-- <button class="btn btn-warning" type="button">
									<i class="fa fa-undo"></i>
									ย้อนกลับ
								</button> -->
								<button class="btn btn-success" type="submit" id="save-bill" disabled>
									<i class="fa fa-check-square-o"></i>
									ชำระเงิน
								</button>
							</td>
						</tr>
					</table>
				</div>
			</div>
		</form>
	</div>
	<script type="text/javascript">
		$(function(){
			$(document).pos();
			$(document).on('scan.pos.barcode', function(event) {
				if(event.code.length != 13) {
					return;
				}
				posProduct(event.code);
			});
		});

		$(document).ready(function() {
			$('#discount, #tax-value').bind('click focus keyup', function(e) {
				if(e.type != 'keyup') {
					$(this).select();
				}
				resetTimeout(1500);
				posCal();
			});

			$('#discount-type, #tax').change(function(e) {
				posCal();
			});

			$('.cancel-all').click(function() {
				if($('.product').length && confirm('ยกเลิกรายการทั้งหมด ?')) {
					posCancelAll();
				}
			});

			$('#product-quantity').keypress(function(e) {
				if(e.which == 13) {
					$('#addbar-form').submit();
				}
			});

			$('#customer-id').focus(function() {
				$(this).select();
			});

			$('#customer-id').keyup(function(e) {
				if(e.which != 13) {
					$('#customer-id-hidden').val(void(0));
				}
				checkSave();

				let v = $(this).val().trim();

				$('#customer-id').autocomplete({
					delay: 100,
					source: '<?=URL::to('customer-get.php?search=');?>'+v,
					minLength: 1,
					select: function(event, ui) {
						console.log("Selected: " + ui.item.name + " aka " + ui.item.id);
						$('#customer-id-hidden').val(ui.item.id);
						resetTimeout(1500);
						checkSave();
					},
					position: {
						my: 'right bottom',
						at: 'right top'
					}
				});
			});

			$('#salesman-id').change(function() {
				checkSave();
			});

			$('#salesman-id').focus(function() {
				resetTimeout(10000);
			});

			$('#new-customer').change(function() {
				let v = $(this).prop('checked');
				if(v) {
					$('#new-customer-row td').css({'padding-top': 8, 'padding-bottom': 8});
					$('#new-customer-row div').css({'height': 70, 'margin-bottom': 15});
					$('#new-customer-row input, #new-customer-row textarea').removeAttr('disabled');
					$('#customer-id').attr('disabled', 'disabled');
				}
				else {
					$('#new-customer-row td').css({'padding-top': 0, 'padding-bottom': 0});
					$('#new-customer-row div').css({'height': 0, 'margin-bottom': 0});
					$('#new-customer-row input, #new-customer-row textarea').attr('disabled', 'disabled');
					$('#customer-id').removeAttr('disabled');
				}
				checkSave();
			});

			$('#remark').focus(function() {
				clearTimeout(focusTimeout);
			});

		});

		focusTimeout = void(0);
		function resetTimeout(itv=1000) {
			clearTimeout(focusTimeout);

			focusTimeout = setTimeout(function() {
				$('#product-id').focus();
			}, itv);
		}

		function posProduct(barcode, quantity = 1) {
			if($('.product#product-'+barcode).length) {
				posIncrement(barcode, quantity);
			}
			else {
				$.ajax({
					url: '<?=URL::to('product-get.php?barcode=');?>'+barcode,
					method: 'get',
					success: function(response) {
						// console.info('response', response);
						if(!response.barcode) {
							$('.no-product').show();
						}
						else {
							$('.no-product').hide();
							posAppend(response, quantity);
						}
					}
				});
			}
		}

		function posAppend(data, quantity = 1) {
			data.quantity = quantity;

			let row = $('<tr class="product" id="product-' + data.barcode + '" data-barcode="' + data.barcode + '">')
			row.append('<td class="center product-order"></td>');
			row.append('<td class="center">' + data.barcode + '</td>');
			row.append('<td>' + data.name + '</td>');
			row.append('<td class="right">' + data.price + '</td>');
			row.append('<td><input id="quantity-' + data.barcode + '" name="product[' + data.barcode + ']" data-barcode="' + data.barcode + '" class="form-control right number product-quantity" type="number" min="1" max="10000" value="' + quantity + '" /></td>');
			row.append('<td id="sum-price-' + data.barcode + '" class="right product-sum-price" data-barcode="' + data.barcode + '" data-price="' + data.price + '">' + number_format(data.price * quantity, 2) + '</td>');
			row.append('<th><i class="fa fa-close fa-button" id="cancel-product-' + data.barcode + '"></i></th>');

			row.css('transition', 'background-color 4s ease');

			if($('.product').length) {
				row.insertAfter('.product:last');
			}
			else {
				row.insertAfter('#holder-row');
				$('#holder-row').hide();
			}

			$('#quantity-' + data.barcode).bind('click focus keyup', function(e) {
				if(e.type != 'keyup') {
					$(this).select();
				}
				resetTimeout(1500);
				posCal();
			});

			$('#cancel-product-'+ data.barcode).click(function() {
				if(confirm('ยกเลิกรายการนี้ ?')) {
					posCancel(data.barcode);
				}
			});

			glow(row);

			posCal();
		}

		function posIncrement(barcode, add_quantity = 1) {
			if($('#quantity-'+barcode).length) {
				let price = parseFloat($('#sum-price-'+barcode).attr('data-price'));
				let new_quantity = parseInt(add_quantity) + parseInt($('#quantity-'+barcode).val());

				$('#quantity-'+barcode).val(new_quantity);
				$('#sum-price-'+barcode)
				.html(number_format(new_quantity * price, 2))
				.attr('data-sum-price', new_quantity * price);
				posCal();

				glow($('#product-'+barcode));
			}
		}

		function posCal() {
			closeAddbar();

			let grandTotal = 0;
			// order
			$('.product-order').each(function(i) {
				$(this).html(i+1);
			});

			// sum quantity
			let sumQuantity = 0;
			$('.product-quantity').map(function() {
				let v = parseInt($(this).val());
				sumQuantity += v;
				return v;
			});
			$('#total-quantity').html(number_format(sumQuantity));

			// sum price
			let sumPrice = 0;
			$('.product-sum-price').map(function() {
				let p = parseFloat($(this).attr('data-price'));
				let q = parseInt($('#quantity-' + $(this).attr('data-barcode')).val());
				let sp = (p*q);

				$('#sum-price-' + $(this).attr('data-barcode')).html(number_format(sp, 2));

				sumPrice += sp;
				return p;
			});
			$('#sub-total').html(number_format(sumPrice, 2));

			// cal discount
			let discount = parseFloat($('#discount').val() || 0);

			if($('#discount-type').prop('checked')) {
				grandTotal = sumPrice - discount;
			}
			else {
				grandTotal = sumPrice - (sumPrice * (discount/100));
				discount = (sumPrice * (discount/100));
			}

			if(discount > sumPrice) {
				$('#discount-bath').html(number_format(sumPrice, 2));
			}
			else if(discount < 0) {
				$('#discount-bath').html('0.00');
			}
			else {
				$('#discount-bath').html(number_format(discount, 2));
			}

			// cal tax

			if($('#tax').prop('checked') && grandTotal > 0) {
				let tax_value = $('#tax-value').val();
				$('#tax-show').html(number_format(grandTotal * (tax_value/100), 2));
				grandTotal = grandTotal + (grandTotal * (tax_value/100));
			}
			else {
				$('#tax-show').html('0.00');
			}

			// grandTotal


			$('#grand-total').html(number_format(grandTotal >= 0 ? grandTotal : 0, 2));

			checkSave();
		}

		function posCancel(barcode) {
			$('#product-'+barcode).remove();
			if(!$('.product').length) {
				$('#holder-row').show();
			}
			posCal();
		}

		function posCancelAll() {
			Promise.all([
				$('.product').remove()
			])
			.then(() => posCal());

			$('#holder-row').show();

		}
	</script>

	<script type="text/javascript">
		function checkSave() {
			if(!$('.product').length || !$('.product-quantity').length) {
				disableSave();
				return;
			}

			if(!$('#salesman-id').val()) {
				disableSave();
				return;
			}

			if(!$('#new-customer').prop('checked') && !$('#customer-id-hidden').val()) {
				disableSave();
				return;
			}

			enableSave();
		}

		function enableSave() {
			$('#save-bill').removeAttr('disabled');
		}

		function disableSave() {
			$('#save-bill').attr('disabled', 'disabled');
		}
	</script>

	<script type="text/javascript">
		function openAddbar() {
			$('#addbar').addClass('open');
			$('#addbar-toggle').addClass('fa-rotate-180');
			$('#product-id').val('').select();
		}

		function closeAddbar() {
			$('#addbar').removeClass('open');
			$('#addbar-toggle').removeClass('fa-rotate-180');
			$('#product-id-hidden, #product-quantity').val(void(0));
			$('.ui-autocomplete').hide();
		}

		$('#addbar-button').click(function() {
			var open = $('#addbar').hasClass('open');
			if(open) {
				closeAddbar();
			}
			else {
				openAddbar();
			}
		});

		$('#product-id').click(function() {
			$(this).select();
		});

		$('#product-id').keyup(function() {
			$('#product-id-hidden').val(void(0));
			let v = $(this).val().trim();

			$('#product-id').autocomplete({
				delay: 100,
				source: '<?=URL::to('product-get.php?search=');?>'+v,
				minLength: 1,
				select: function(event, ui) {
					//console.log("Selected: " + ui.item.name + " aka " + ui.item.id);
					$('#product-id-hidden').val(ui.item.barcode);
					$('#product-quantity').select();
				},
				position: {
					my: 'right bottom',
					at: 'right top'
				}
			});
		});

		$('#addbar-form').submit(function(e) {
			e.preventDefault();
			if($('#product-id-hidden').val() != '') {
				posProduct($('#product-id-hidden').val(), $('#product-quantity').val());
			}
			else{
				$('#product-id').select();
			}
		})
	</script>
</body>
</html>
