<?php
	require 'include/lib.php';

	if(isset($_POST['submit']) && $_POST['submit'] == 'invoice') {
		if(isset($_POST['method']) && $_POST['method'] == 'create') {
			// HTML::pre($_POST);
			$result = Invoice::create();
			// HTML::pre($result);

			if(!$result['error']) {
				HTML::script('alert("ออกใบวางบิลสำเร็จ");');
				URL::redirect('invoice-update.php?id='.$result['result']['id']);
			}
		}
	}

	$customer_show = false;
	if(isset($_GET['customer-id']) && intval($_GET['customer-id']) > 0) {
		$customer_show = Customer::detail(intval($_GET['customer-id']));
	}
?>
<!DOCTYPE html>
<html>
<?php include 'head.html'; ?>
<body>
	<?php include 'navbar.php'; ?>
	<div class="container">
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
				<h1>ออกใบวางบิล</h1>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
				<div class="panel panel-warning">
					<div class="panel-body">
						<form method="get" class="form-inline">
							<label for="">วันที่</label>
							<input type="date" name="date-from" class="form-control" value="<?=isset($_GET['date-from']) ? $_GET['date-from'] : '';?>">
							&emsp;
							<label for="">ถึง</label>
							<input type="date" name="date-to" class="form-control" value="<?=isset($_GET['date-to']) ? $_GET['date-to'] : '';?>">

							<br/>
							<br/>

							<label for="">ลูกค้า</label>
							<input type="hidden" id="customer-id-hidden" name="customer-id" value="<?=($customer_show && $customer_show['id'] ? $customer_show['id'] : '');?>" />
							<input class="form-control center number" id="customer-id" type="text" placeholder="ค้นหาลูกค้า" size="50" value="<?=($customer_show  ? ($customer_show['name'].($customer_show['nickname'] ? ' ('.$customer_show['nickname'].')' : '')) : '');?>" autocomplete="off"/>
							&emsp;
							<label for="">ภาษี</label>
							<select name="tax" class="form-control" id="" required>
								<option value="all" selected>ทั้งหมด</option>
								<option value="tax" <?=isset($_GET['tax']) && $_GET['tax'] == 'tax'? 'selected' : '';?> >คิดภาษี</option>
								<option value="notax" <?=isset($_GET['tax']) && $_GET['tax'] == 'notax'? 'selected' : '';?> >ไม่คิดภาษี</option>
							</select>

							<br/>
							<br/>

							<button class="btn btn-primary" type="submit">
								<i class="fa fa-search"></i>
								ค้นหา
							</button>
							<button type="button" class="btn btn-warning" onclick="window.location='<?=URL::to('bill.php');?>'">
								<i class="fa fa-undo"></i>
								ล้าง
							</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<form method="post">
			<input type="hidden" name="submit" value="invoice" />
			<input type="hidden" name="method" value="create" />
			<div class="row">
				<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
					<div class="panel panel-warning">
						<div class="panel-heading center">
							<h3 class="center">รายการบิล </h3>
							<!-- <input id="invoice-number" name="invoice-number" type="checkbox" data-toggle="toggle" data-style="invoice-number" data-on="ใช้เลขเล่ม" data-off="ไม่ใช้เลขเล่ม" data-onstyle="info" /> -->

						</div>
						<table class="table table-hover b-table">


							<?php
								if(isset($_GET['date-from']) || isset($_GET['date-to']) || isset($_GET['tax'])) {
									$datas = Bill::lists();

									if(sizeof($datas) == 0) {
										echo '<tr class="heading">';
											echo '<td class="center" colspan="8">ไม่พบข้อมูลการขายที่ค้นหาในระบบ</td>';
										echo '</tr>';
									}
									else {
										echo '<tr class="heading">
											<th width="10%"><input id="select-all" type="checkbox" data-toggle="toggle" data-style="invoice-number" data-size="small" data-on="เลือกทั้งหมด" data-off="ไม่เลือก" data-onstyle="success" data-offstyle="danger" checked/></th>
											<th width="5%">เลขที่บิล</th>
											<th width="10%">วันที่</th>
											<th width="35%">ลูกค้า</th>
											<th width="5%">ภาษี</th>
											<th width="15%">สุทธิ</th>
											<th width="10%">รายละเอียด</th>
										</tr>';
										$cnt = 0;
										$total = 0;
										foreach ($datas as $key => $data) {
											++$cnt;
											$total += $data['total'];

											$customer = Customer::detail($data['customer_id']);

											echo '<tr>';
												echo '<th><input data-total="'.$data['total'].'" class="check-bill" name="bill['.$data['id'].']" type="checkbox" data-toggle="toggle" data-style="invoice-number" data-size="small" data-on="<i class=\'fa fa-check\'></i>" data-off="<i class=\'fa fa-close\'>" data-onstyle="success" checked/></th>';
												echo '<td class="center">'.$data['sequence'].'</td>';
												echo '<td>'.ThaiDate::toThaiDate($data['created_at'], 'd M Y').'</td>';
												echo '<td>'.$customer['name'].($customer['nickname'] ? ' ('.$customer['nickname'].')' : '').'</td>';
												echo '<td class="center">'.($data['tax_value'] > 0 ? ($data['tax_value'] % 1 == 0 ? intval($data['tax_value']) : number_format($data['tax_value'], 2)).'%' : '-').'</td>';
												echo '<td class="right">'.number_format($data['total'], 2).'</td>';

												echo '<td class="center" width="5%">
													<a href="'.URL::to('bill-detail.php?id='.$data['id']).'" target="_blank">
														<i class="fa fa-eye fa-button"></i>
													</a>
												</td>';

											echo '</tr>';
										}
										echo '<tr class="heading">
											<th colspan="5">รวมที่เลือก <span id="bill-count">'.number_format($cnt).'</span> บิล</th>
											<th class="right" id="grand-total">'.number_format($total, 2).'</th>
											<td></td>
										</tr>';
									}
								}
								else {
									echo '<tr class="heading">
										<th colspan="8">โปรดเลือกช่วงวันที่ ในการออกใบวางบิล</th>
									</tr>';
								}

							?>
						</table>
					</div>
				</div>
			</div>
			<div class="row">

				<div class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
					<div class="form-group">
						<label for="">ลูกค้า *</label>
						<input type="hidden" id="customer-id-hidden-invoice" name="customer-id" required/>
						<input class="form-control center number" id="customer-id-invoice" type="text" placeholder="ค้นหาลูกค้า" size="50" autocomplete="off" required/>
					</div>
				</div>
				<div class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
					<div class="form-group">
						<label for="">พนักงาน *</label>
						<select class="form-control" name="salesman-id" id="salesman-id" required>
							<option value="" disabled selected>-- เลือกพนักงานขาย --</option>
							<?php
								$datas = Salesman::lists();

								if(sizeof($datas) > 0) {
									$cnt = 0;
									foreach ($datas as $key => $data) {
										echo '<option value="'.$data['id'].'">'.$data['title'].$data['firstname'].' '.$data['lastname'].($data['nickname'] ? ' ('.$data['nickname'].')' : '').'</option>';;
									}
								}
							?>
						</select>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
					<div class="form-group">
						<label for="">ข้อมูลใบวางบิล *</label>
						<textarea name="name" class="form-control" id="" cols="30" rows="2" placeholder="ข้อมูลใบวางบิล" style="resize: none;" required><?=isset($_POST['address']) ? $_POST['address'] : '';?></textarea>
					</div>
					<div class="form-group center">
						<button type="reset" class="btn btn-warning">
							<i class="fa fa-undo"></i>
							ล้าง
						</button>
						<button type="submit" class="btn btn-success" id="save-invoice">
							<i class="fa fa-plus"></i>
							ออกใบวางบิล
						</button>
					</div>
				</div>
			</div>
		</form>
	</div>
	<script type="text/javascript">
		function calTotal() {
			let grand_total = 0;
			$('.check-bill:checked').each(function() {
				grand_total += parseFloat($(this).attr('data-total'));

			});

			$('#grand-total').html(number_format(grand_total, 2));
			$('#bill-count').html(number_format($('.check-bill:checked').length));

			if($('.check-bill:checked').length == 0) {
				$('#save-invoice').attr('disabled', 'disabled');
				return;
			}
			else {
				$('#save-invoice').removeAttr('disabled');
			}

			if(!$('#customer-id-hidden-invoice').val()) {
				$('#save-invoice').attr('disabled', 'disabled');
				return;
			}
			else {
				$('#save-invoice').removeAttr('disabled');
			}

		}

		$(document).ready(function() {
			$('.check-bill').change(function() {
				calTotal();
			});

			$('#select-all').change(function() {
				$('.check-bill').bootstrapToggle($(this).prop('checked') ? 'on' : 'off')

				calTotal();
			});

			calTotal();

			$('#customer-id, #customer-id-invoice').focus(function() {
				$(this).select();
			});

			$('#customer-id').keyup(function(e) {
				if(e.which != 13) {
					$('#customer-id-hidden').val(void(0));
				}

				let v = $(this).val().trim();

				$('#customer-id').autocomplete({
					delay: 100,
					source: '<?=URL::to('customer-get.php?search=');?>'+v,
					minLength: 1,
					select: function(event, ui) {
						
						$('#customer-id-hidden').val(ui.item.id);
					},
					position: {
						my: 'right bottom',
						at: 'right top'
					}
				});
			});

			$('#customer-id-invoice').keyup(function(e) {
				if(e.which != 13) {
					$('#customer-id-hidden-invoice').val(void(0));
				}
				calTotal();

				let v = $(this).val().trim();

				$('#customer-id-invoice').autocomplete({
					delay: 100,
					source: '<?=URL::to('customer-get.php?search=');?>'+v,
					minLength: 1,
					select: function(event, ui) {
						$('#customer-id-hidden-invoice').val(ui.item.id);
						calTotal();
					},
					position: {
						my: 'right bottom',
						at: 'right top'
					}
				});
			});
		});
	</script>
	<?php
		if(isset($result)) {
			if($result['error']) {
				echo HTML::inputAlert('input[name="firstname"]', 'danger', 'ช้อมูลไม่ถูกต้อง');
			}
		}
	?>
</body>
</html>
