<?php
	require 'include/lib.php';

	if(!isset($_GET['id']) || !intval($_GET['id'])) {
		HTML::script('alert("ไม่พบข้อมูล");window.close();');
	}

	$id = intval($_GET['id']);

	$data = Invoice::detail($id);

	$salesman = Salesman::detail($data['salesman_id']);
	$customer = Customer::detail($data['customer_id']);

	$title = 'Invoice-'.str_replace('.', '', $customer['name']).'-'.str_replace('.', '', $customer['nickname']).'-'.intval($data['sequence']);
?>
<!DOCTYPE html>
<html>
<?php include 'head-print.html'; ?>
<body>
	<table width="100%">
		<tr>
			<td>
				<?=$salesman['title'].$salesman['firstname'].' '.$salesman['lastname'];?>
			</td>
			<td class="right">
				<?=($data['number'] ? 'เล่มที่ '.number_format($data['number']) : '');?>
			</td>
		</tr>
		<tr>
			<td>
				<?=$salesman['address'];?>
			</td>
			<td class="right">
				เล่มที่ <?=intval($data['sequence']);?>
			</td>
		</tr>
		<tr>
			<td>
				โทรศัพท์ : <?=($salesman['phone'] ? $salesman['phone'] : '-');?>&emsp;
				มือถือ : <?=($salesman['mobile'] ? $salesman['mobile'] : '-');?>&emsp;
				เลขประจำตัวผู้เสียภาษี : <?=($salesman['fax'] ? $salesman['fax'] : '-');?>
			</td>
			<td class="right">
				<?=ThaiDate::toThaiDate($data['created_at'], 'd M Y');?>
			</td>
		</tr>
	</table>
	<br/>
	<table width="100%">
		<tr>
			<td class="bdt bdl bdr bdb">
				ที่อยู่ลูกค้า : <?=$customer['address'];?>
			</td>
		</tr>
		<tr>
			<th class="bdl bdr bdb">
				ใบวางบิล <?=$customer['name'];?> สาขา <?=$customer['nickname'];?>
			</th>
		</tr>
	</table>
	<table width="100%">
		<tr>
			<td width="20%" class="center bdl bdr bdb">ลำดับ</td>
			<td width="20%" class="center bdr bdb">เลขที่บิล</td>
			<td width="20%" class="center bdr bdb">วันที่บิล</td>
			<td width="20%" class="center bdr bdb">วันครบกำหนด</td>
			<td width="20%" class="center bdr bdb">จำนวนเงิน</td>
		</tr>
		<?php
			$_POST['invoice_id'] = $data['id'];
			$bills = Bill::lists();

			$cnt = 0;
			$total = 0;

			if(sizeof($bills) == 0) {
				echo '<tr>';
					echo '<td class="center bdl bdr bdb" colspan="4">ไม่พบข้อมูลการขายในระบบ</td>';
				echo '</tr>';
			}
			else {
				foreach ($bills as $key => $bill) {
					
					$total += floatval($bill['total']);
					echo '<tr>';
						echo '<td class="center bdl bdr bdb">'.(++$cnt).'</td>';
						echo '<td class="center bdl bdr bdb">'.number_format($bill['sequence']).'</td>';
						echo '<td class="center bdl bdr bdb">'.ThaiDate::toThaiDate($bill['created_at'], 'd M Y').'</td>';
						echo '<td class="bdr bdb">'.$bill['customer_name'].($bill['customer_nickname'] ? ' ('.$bill['customer_nickname'].')' : '').'</td>';
						echo '<td class="right bdr bdb">'.number_format($bill['total'], 2).'</td>';
						
						
					echo '</tr>';
				}
			}
			
			$grand_total = $total;

			$margin = 28;
			if($cnt < $margin) {
				$rows = $margin-$cnt;
				for($i = 0; $i < $rows; ++$i) {
					echo '<tr class="holder">';
						echo '<td class="bdl bdr">&nbsp;</td>';
						echo '<td class="bdr"></td>';
						echo '<td class="bdr"></td>';
						echo '<td class="bdr"></td>';
						echo '<td class="bdr"></td>';
					echo '</tr>';
				}
			}
			
		?>
		<tr>
			<td colspan="4" class="center bdl bdt bdr bdb">
				รวม
			</td>
			<td class="right bdt bdr bdb">
				<?=number_format($grand_total, 2);?>
			</td>
		</tr>
		<tr>
			<td colspan="5" class="center vat bdt bdl bdr bdb">
				<?=BahtText::toBahtText($grand_total);?>
			</td>
		</tr>
	</table>
	<table width="100%">
		<tr>
			<td class="bdl bdr">
				<br/>
			</td>
			<td class="bdr">
				<br/>
			</td>
		</tr>
		<tr>
			<td class="center bdl bdr" width="50%">
				ลงชื่อ .................................................. ผู้วางบิล
			</td>
			<td class="center bdr" width="50%">
				ลงชื่อ .................................................. ผู้รับวางบิล
			</td>
		</tr>
		<tr>
			<td class="center bdl bdr">(<?=$salesman['title'].$salesman['firstname'].' '.$salesman['lastname'];?>)</td>
			<td class="center bdr">(..................................................)</td>
		</tr>
		<tr>
			<td class="center bdl bdr">วันที่ ........../........../..........</td>
			<td class="center bdr">วันที่ ........../........../..........</td>
		</tr>
		<tr>
			<td class="bdl bdr bdb">
				<br/>
			</td>
			<td class="bdr bdb">
				<br/>
			</td>
		</tr>
	</table>
	<script type="text/javascript">
		$().ready(function(){
			window.print();
			setTimeout(function(){
				window.close();
			}, 1);
		});
	</script>
</body>
</html>