<?php
	require 'include/lib.php';

	if(!isset($_GET['id']) || !intval($_GET['id'])) {
		URL::redirect('product.php');
	}

	$id = intval($_GET['id']);

	if(isset($_POST['submit']) && $_POST['submit'] == 'product') {
		if(isset($_POST['method']) && $_POST['method'] == 'update') {
			$result = Product::update($id);
		}
	}

	$data = Product::detail($id);
	if(!$data) {
		HTML::script('alert("ไม่พบข้อมูล");');
		URL::redirect('product.php');
	}
?>
<!DOCTYPE html>
<html>
<?php include 'head.html'; ?>
<body>
	<?php include 'navbar.php'; ?>
	<div class="container">
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
				<h1>แก้ไขข้อมูลสินค้า</h1>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
				<div class="col-xs-6 col-sm-6 col-md-6 col-lg-6" style="margin: auto; float: none;">
					<div class="panel panel-warning">
						<div class="panel-body">
							<form method="post">
								<input type="hidden" name="submit" value="product" />
								<input type="hidden" name="method" value="update" />
								<input type="hidden" name="product-id" value="<?=$id;?>" />
								<div class="form-group">
									<label for="">รหัสสินค้า *</label>
									<input id="product-barcode-text" name="barcode" class="form-control barcode-text center" type="text" placeholder="รหัสสินค้า" value="<?=isset($data['barcode']) ? $data['barcode'] : '';?>" autocomplete="off" maxlength="13" required/>
								</div>

								<div class="form-group center">
									<svg id="product-barcode" class="barcode"/>
								</div>
								
								<div class="form-group">
									<label for="">ชื่อสินค้า *</label>
									<input id="product-name" name="name" class="form-control" type="text" placeholder="ชื่อสินค้า" value="<?=isset($data['name']) ? $data['name'] : '';?>" autocomplete="off" required/>
								</div>

								<div class="form-group">
									<label for="">คำอธิบาย</label>
									<textarea name="description" class="form-control" id="" cols="30" rows="5" placeholder="คำอธิบาย" style="resize: none;"><?=isset($data['description']) ? trim($data['description']) : '';?></textarea>
									
								</div>
								<div class="form-group">
									<label for="">ราคา *</label>
									<input name="price" class="form-control" type="number" placeholder="ราคา" min="0.25" step="0.25" value="<?=isset($data['price']) ? $data['price'] : '';?>" required/>
								</div>
								<div class="form-group center">
									<button type="reset" class="btn btn-warning">
										<i class="fa fa-undo"></i>
										ล้าง
									</button>
									<button type="submit" class="btn btn-success">
										<i class="fa fa-plus"></i>
										แก้ไขข้อมูลสินค้า
									</button>
								</div>
							</form>
						</div>
					</div>
				</div>
				
			</div>
		</div>
	</div>
	<script type="text/javascript">
		$(function(){
			$(document).pos();
			$(document).on('scan.pos.barcode', function(event) {
				handleBarcode('#product-barcode-text', event.code, function () {
					previewBarcode('#product-barcode', event.code);
					$('#product-name').focus();
				});
				
			});
		});
		
		previewBarcode('#product-barcode', '<?=$data['barcode'];?>');
		
		$(document).ready(function(){
			// preview barcode on product create or update
			$('.barcode-text').keyup(function() {
				let bid = ('#'+$(this).attr('id')).split('-');
				
				bid = bid.filter((b, index)=> index < bid.length - 1);
				bid = bid.join('-');
				previewBarcode(bid, $(this).val());
			});
		});
	</script>
	<?php
		if(isset($result)) {
			if($result['error']) {
					if($result['result'] == 'barcode_dup') {
					echo HTML::inputAlert('input[name="barcode"]', 'danger', 'รหัสสินค้านี้มีในระบบแล้ว');
				}

				if($result['result'] == 'name_dup') {
					echo HTML::inputAlert('input[name="name"]', 'danger', 'ชื่อสินค้านี้มีในระบบแล้ว');
				}
			}
			else{
				echo HTML::inputAlert('input[name="barcode"]', 'success', 'แก้ไขข้อมูลสินค้าสำเร็จ');
			}
		}
	?>
</body>
</html>